#!/usr/bin/python

# Parsely - A cross-language tool for parsing and file manipulation.
#
# Copyright (C) 1999-2000 Nick Mathewson
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

"""The main module for parsely."""

# Note: my target platform for the parsely code is currently Python 1.5.1.

import string
import parsely._util
from types import StringType, ListType, TupleType

__all__ = [ 'tree', 'format' ]

VERSION = "0.1.0"

class ParselyException(Exception):
    """This base class is a parent to all exceptions thrown from the parsely
       modules."""

    # Fields:
    #   msg - a human-readable message
    def __init__(self,msg=None):
        """Create a new ParselyException.

           s - a string, a list, or None to indicate more information
               about this exception."""

        # Must be derived
        assert self.__class__ is not ParselyException
        
	if type(msg) is StringType:
	    self.msg = s
	elif type(msg) in (ListType, TupleType):
	    self.msg = string.join(msg, ' ')
        elif s is None:
            self.msg = ""
        else:
            self.msg = str(msg)

    def __str__(self):
        """Returns the message for this exception."""
        return self.msg

def loadFileFormat(fileName, path=None):
    import parsely.grammar
    return parsely.grammar.generateFileFormat(
	parsely._util.fileContents(fileName,path=path))

def loadFormat(baseFileName, compile=1):    
    """Tries to load a file format with a given name.  First, searches in
       <baseFileName>.ply for a format specification, and in
       <baseFileName>.plyC for a compiled format specification.
       If the compiled format exists and is up-to-date, reads it.
       Otherwise, tries to read and compile the origininal format
       specification.

       BUGBUGBUGBUG: The .plyC aspect of this function simply doesn't
       work.  There's parts of the format structure that don't seem to
       unpickle cleanly, but instead create a stack overflow.  I'll
       fix this eventually, but it's not a big priority; anybody who
       cares so much about speed is as likely to use C.

       If compile is false, does not regenerate <baseFileName>.plyC

       Modifies: the file <baseFileName>.plyC"""

    if 1:
	return loadFileFormat(baseFileName + ".ply")

    import os
    import parsely.grammar

    originalName = baseFileName + ".ply"
    compiledName = baseFileName + ".plyC"

    oExists = os.path.exists(originalName)
    cExists = os.path.exists(compiledName)
    oTime = oExists and os.stat(originalName)[9]
    cTime = cExists and os.stat(compiledName)[9]

    if cExists and (not oExists or cTime > oTime):
        import pickle, parsely.format 
	if 1:
	#try: #XXXX
            f = open(compiledName,'rb')
            fmt = pickle.load(f)
            f.close()
            if not isinstance(fmt, parsely.format.FileFormat):
                print "%s didn't contain a FileFormat" % (compiledName)
            return fmt
        #except:
        #    print "Error while trying to read %s" % compiledName
        #    return None
    elif oExists:
        import grammar
        f = open(originalName,'r')
        s = f.read()
        f.close()
        fmt = parsely.grammar.generateFileFormat(s)
        if fmt and compile:
            import pickle
            #try:
	    if 1: #XXXX
                f = open(compiledName, 'wb')
                p = pickle.Pickler(f,1)
                p.dump(fmt)
                f.close()
            #except:
            #    print "Warning: couldn't regenerate %s" % compiledName
	
	return fmt
    else:
        return None

def _testPcreHack():
    """Sets use_pcre_hack to 1 iff the re.code field works as we expect.

       Not for extenal use; we only bundle this as a function so that it
       can have local variables"""
    global use_pcre_hack
    import re
    try:
	pat = re.compile("(abc)|(def)")
	code = pat.code
	regs = code.match('def',0,len('def'),re.ANCHORED)
	if regs is not None:
	    m = -1
	    for i in range(1,len(regs)):
		if regs[i][0] == -1 or regs[i][1] == -1:
		    continue
		else:
		    m = i
	    if m == 2:
		use_pcre_hack = 1
		return
	use_pcre_hack = 0
    except:
        use_pcre_hack = 0



# If this field is 1, we'll use the undocumented re.code field to improve
# performance.
use_pcre_hack = 0
_testPcreHack()

# If this field is 1, then includes are assumed to work, and aren't disabled.
# Don't turn this field on unless you're developing Parsely.
INCLUDES_ENABLED = 0

