#!/usr/bin/python

# Parsely - A cross-language tool for parsing and file manipulation.
#
# Copyright (C) 1999-2000 Nick Mathewson
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

"""XXXX-C"""

from parsely._util import UniqueIDDomain

class CIdentifiers:
    def __init__(self, module_name, write_dir):
	self.writeDir = write_dir
	self.moduleName = module_name
	if module_name is None:
	    self.fileNameBase = "parsely_out"
	    self.IDPrefix = ""
	    self.yy = "yy"
	else:
	    self.fileNameBase = module_name
	    self.IDPrefix = CIDify(self.module_name) + "_"
	    self.yy = self.IDPrefix + "yy"
	if write_dir:
	    self.fileNameBase = os.path.join(write_dir, self.fileNameBase)

    def getLexFilename(self):
	return self.fileNameBase + "_scan.l"
    
    def getYaccFilename(self):
	return self.fileNameBase + "_parse.y"

    def getYaccHFilename(self):
	return self.fileNameBase + "_parse.h"

    def getCodeFilename(self):
	return self.fileNameBase + ".c"
    
    def getHeaderFilename(self):
	return self.fileNameBase + ".h"

    def getStateName(self,name):
	return self.IDPrefix + "S_" + CIDify(name)

    def getPatName(self, name):
	# XXXX-C Necessary?
	return self.IDPrefix + "PAT_" + CIDify(name)
    
    def getTokName(self, name):
	return self.IDPrefix + "TOK_" + CIDify(name)

    def getTypeName(self, name):
	return self.IDPrefix + "T_" + CIDify(name)
    

class _CIDifyDomain(UniqueIDDomain):
    'XXXX-C'
    def __init__(self):
	UniqueIDDomain.__init__(self)
	self.re = re.compile(r"[^A-Za-z0-9_]")
    
    def _transform(self, id):
	return self.re.sub("_",id)

_theCIDifyDomain = _CIDifyDomain()

def CIDify(id):
    'XXXX-C'
    return _theCIDifyDomain.get(id)

if __name__ == '__main__':
    import parsely._util, sys
    import parsely.grammar
    parsely._util._trimFrileFromArgv('cTrans')

    fname = sys.argv[0]
    fmt = parsely.grammar.generateFileFormat(
	parsely._util.fileContents(fname), V=0)
    

    
