#!/usr/bin/python

# Parsely - A cross-language tool for parsing and file manipulation.
#
# Copyright (C) 1999-2000 Nick Mathewson
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

"""The pyTrans module contains the translator for actions in Python."""

import string,re
from parsely.format import ActionTranslator, GrammarError, _ActionUnit

class PythonActionTranslator(ActionTranslator):
    def __init__(self,context):
        # (we don't do LALR parsers.)
        assert context in ('scanner', 'parser')        
        ActionTranslator.__init__(self, 'python', context)
    
    # XXXX Doc: why is this necessary?
    __REGEXEN = {
        'CONTINUE'    : (re.compile(r'\bCONTINUE\b'),    'SpP'),
        }

    def getRegexen(self):
        return PythonActionTranslator.__REGEXEN

    def t_CONTINUE(self, m):        
	return "raise 'ExplicitContinue'"

    def compile(self, actionTarget):
        """Given an _ActionUnit or an Action, returns a function for
	   its action, if any."""
        if isinstance(actionTarget, _ActionUnit):
	    a = actionTarget.getAction('python')
	else:
	    a = actionTarget
        if not a:
            return None
        code = self.translate(a.getCode())
	code = self.stripLeadingSpace(code)
        compiled_code = compile(code, "<string>", 'exec')
        return compiled_code


    _initialSpaceRE = re.compile(r'^([ \t]*)[^\s#\n]', re.M)

    def stripLeadingSpace(self, code):
        """Given a string with leading space, tries to remove that amount
           of space from the beginning of every line."""

	m = PythonActionTranslator._initialSpaceRE.search(code)
	m = m.group(1)
	m = string.replace(m,"\t","        ")
	l = len(m)
	lines = string.split(code,"\n")
	for i in range(0,len(lines)):
	    line = lines[i]
	    line = string.replace(line,"\t","        ")
	    if len(line) >= l and line[:l] == m:
		line = line[l:]
            # This isn't too robust.  If we have a line that isn't
            # indented enough, it will silently ignore it.
	    lines[i] = line
	return string.join(lines,'\n') + "\n"
