#!/usr/bin/python

# Parsely - A cross-language tool for parsing and file manipulation.
#
# Copyright (C) 1999-2000 Nick Mathewson
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import os, pprint, sys
from parsely.grammar import generateFileFormat
from parsely._util import fileContents
import parsely
import cStringIO, glob
import traceback

def errorFromStr(fn,s):
    "XXXX"

    oldStdOut = sys.stdout
    sys.stdout = cStringIO.StringIO()
    ex = ""

    try:
	format = generateFileFormat(s)

	err = sys.stdout.getvalue()
	sys.stdout.close()
	sys.stdout = oldStdOut

    except Exception, e:

	err = sys.stdout.getvalue()
	sys.stdout.close()
	sys.stdout = oldStdOut

	ex = str(e.__class__) + ": " + str(e)

	if not isinstance(e, parsely.grammar.GrammarError):
	    print fn
	    traceback.print_exc()

    if ex:
	err = err + ex

    return err

def removeIfPresent(*files):
    for fname in files:
	try:
	    os.remove(fname)
	except:
	    pass

def doTest(nameBase):
    grammar  = fileContents(nameBase + ".ply")
    expected = fileContents(nameBase + ".out",default="")

    removeIfPresent(nameBase + ".err")

    got      = errorFromStr(nameBase + ".ply" , grammar)

    if expected == got:
	print "OK", nameBase
	return 1
    else:
	f = open(nameBase +  '.err', 'w')
	f.write(got)
	f.close()
	print "FAIL", nameBase, "(output written to %s.err)" % nameBase
	return 0

def testAllFiles():
    ok = fail = 0
    files = glob.glob('./tests/badGrammars/*.ply')
    files.sort()
    for fn in files:
	fn = fn[:-4] #strip the '.ply'
	if doTest(fn):
	    ok = ok + 1
	else:
	    fail = fail + 1

    return ok,fail

if __name__ == '__main__':
    o,f = testAllFiles()
    print f, "tests failed"
    print o, "tests passed"

    
