#!/usr/bin/python

# Parsely - A cross-language tool for parsing and file manipulation.
#
# Copyright (C) 1999-2000 Nick Mathewson
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import os, pprint
from parsely.dumpFormat import dumpFormat
from parsely.grammar import generateFileFormat
from parsely._util import fileContents

_cached_formats = {}
def grammarFromFile(fname):
    "XXXX"
    if _cached_formats.has_key(fname):
	return _cached_formats[fname]

    format = generateFileFormat(fileContents(fname))
    _cached_formats[fname] = format
    return format

def removeIfPresent(*files):
    for fname in files:
	try:
	    os.remove(fname)
	except:
	    pass

def validGrammarTest(grammarFname, fnameBase):
    inp = fileContents(fnameBase + ".in")
    correct_out = fileContents(fnameBase + ".out", default="")
    fmt = grammarFromFile(grammarFname)
    
    node = fmt.parse(inp)
    pp = pprint.PrettyPrinter(indent=4)
    
    received_out = pp.pformat(node.sExpression())

    removeIfPresent(fnameBase + ".err")

    if correct_out == received_out:
	print "OK   %s(%s)" % (grammarFname, fnameBase)
	return 1
    else:
	got = open(fnameBase + ".err", 'w')
	got.write(received_out)
	got.close()
	print "FAIL %s(%s) (Output written to %s.err)" % \
	      (grammarFname, fnameBase, fnameBase)
	return 0

def dumpGrammarTest(grammarFName, expectedFName):
    fmt = grammarFromFile(grammarFName)
    expected = fileContents(expectedFName)
    result = dumpFormat(fmt,V=1)

    removeIfPresent(expectedFName + ".err",
		    expectedFName + ".diff")

    if expected == result:
        print "OK   %s(%s)" % (grammarFName, expectedFName)
	return 1
    else:
        got = open(expectedFName + ".err", 'w')
        got.write(result)
        got.close()
	os.system("diff -u %s %s.err > %s.diff" % 
		  (expectedFName, expectedFName, expectedFName))
        print "FAIL %s(%s) (Output written to %s.err)" % \
	      (grammarFName, expectedFName, expectedFName)
	return 0

grammar_tests = [
    ('basic_kvl.ply',       'basic_kvl.dump'),
    ('complex_grammar.ply', 'complex_grammar.dump'),
    ('scanner1.ply',        'scanner1.dump'),    
    ('scanner2.ply',        'scanner2.dump'),    
    ('complex_grammar_opt.ply', 'complex_grammar_opt.dump'),
    ('tokensTest.ply',      'tokensTest.dump'),
    ('macros.ply',          'macros.dump'),
    ]
    
parse_tests = [ 
    ('basic_kvl.ply',       'basic_kvl'),
    ('basic_kvl.ply',       'basic_kvl_empty'),
    ('complex_grammar.ply', 'complex_grammar'),
    ('complex_grammar_opt.ply',    'complex_grammar_opt'),
    ('actions1.ply',        'actions1'),
    ('actions2.ply',        'actions2'),
    ('actions3.ply',        'actions3'),
    ]

def runValidTests():
    ok = fail = 0

    for g,d in grammar_tests:
	if dumpGrammarTest("tests/" + g, "tests/" + d):
	    ok = ok + 1
	else:
	    fail = fail + 1
		        
    for g, f in parse_tests:
	if validGrammarTest("tests/" + g, "tests/" + f):
	    ok = ok + 1
	else:
	    fail = fail + 1

    return ok,fail

if __name__ == '__main__':
    o, f = runValidTests()
    print f, "tests failed"
    print o, "tests passed"
    
    
    
    
