#!/usr/bin/perl -w

#
# Builds a module dependency diagram.
#

for $fname (@ARGV) {
    open(F, $fname);
    %importedNames = ();
    %uses = ();
    $fromContinuation = 0;
    %packages = ();
    while (<F>) {
	if (/^from\s+(parsely[\w\.]*)\s+import ([^\\]*)(\\?)$/) {
	    $packages{$1} = 1;
	    $fromContinuation = ($3 ne '');
	    $curpkg = $1;
	    addNames($1, $2);
	} elsif ($fromContinuation) {
	    /([^\\]*)(\\?)$/;
	    $fromContinuation = ($2 ne '');
	    addNames($curpkg, $1);
	} else {
	    while (/(parsely\.[\w\.]+)/g) {
		$uses{$1} = 1;
		$name = $1;
		$name =~ s/\.[^\.]+$//;
		$packages{$name} = 1;
	    }
	}
    }

    print "=== $fname\n";
    for $k (keys %packages) {
	print "  uses package $k\n";
    }

    #for $v (values %importedNames) {
#	print "  imports $v\n";
#    }
#    for $k (keys %uses) {
#	print "  uses $k\n";
#    }
    

}

sub addNames {
    my ($pkg, $names) = @_;

    for my $n (split(/[,\s]+/, $names)) {
	print "Duplicate  import for $n! ($fname:$.)" 
	    if (exists $importedNames{$n});
	$importedNames{$n} = "$pkg.$n";
    }

}
