#!/usr/bin/perl -w

$inClass = 0;

$nClass = 0;
$nField = 0;

%names = ();
while(<>) {    
    if (/^class\s+(\w+)/) {
	if ($inClass) {
	    for $n (sort keys %names) { print "   $n\n"; }
	}
	$classname = $1;
	$mod = $ARGV;
	$mod =~ s!/!.!g;
	$mod =~ s!\.py$!!;
	print "==== $mod.$classname\n";
	$inClass = 1;
	%names = ();
	++$nClass;
    } elsif (/^[^\#\s]/) {
	if ($inClass) {
	    for $n (sort keys %names) { print "   $n\n"; }
	}
	$inClass = 0;
    } elsif (/self.__dict__\[([^\]]*?)\]/ or
	     /self\.(\w+)[^\(\w]/) {
	if ($inClass) { 
	    $names{$1} = 1;
	    ++$nField;
	} else {
	    print "??$1\n";
	}  
    }
}

if ($inClass) {
    for $n (sort keys %names) { print "   $n\n"; }
}

print "$nField fields in $nClass classes.\n";

